<?php

use App\Core\Router;
use App\Controllers\AuthController;
use App\Controllers\EntrepreneurController;
use App\Controllers\InvestorController;
use App\Controllers\AdminController;
use App\Controllers\MentorController;
use App\Middleware\AuthMiddleware;
use App\Middleware\AdminMiddleware;
use App\Middleware\EntrepreneurMiddleware;
use App\Middleware\InvestorMiddleware;
use App\Middleware\MentorMiddleware;

$router = new Router();

// Public routes
$router->get('/', function() {
    view('home');
});

$router->get('/about', function() {
    view('about');
});

$router->get('/contact', function() {
    view('contact');
});

// Auth routes
$router->get('/login', 'App\Controllers\AuthController@showLogin');
$router->post('/login', 'App\Controllers\AuthController@login');
$router->get('/register', 'App\Controllers\AuthController@showRegister');
$router->post('/register', 'App\Controllers\AuthController@register');
$router->get('/verify-email', 'App\Controllers\AuthController@verifyEmail');
$router->get('/logout', 'App\Controllers\AuthController@logout');

// Entrepreneur routes
$router->get('/entrepreneur/dashboard', 'App\Controllers\EntrepreneurController@dashboard', [EntrepreneurMiddleware::class]);
$router->get('/entrepreneur/apply', 'App\Controllers\EntrepreneurController@showApplicationForm', [EntrepreneurMiddleware::class]);
$router->post('/entrepreneur/apply', 'App\Controllers\EntrepreneurController@submitApplication', [EntrepreneurMiddleware::class]);
$router->get('/entrepreneur/pay-application/{id}', 'App\Controllers\EntrepreneurController@showPaymentPage', [EntrepreneurMiddleware::class]);
$router->get('/entrepreneur/verify-payment', 'App\Controllers\EntrepreneurController@verifyPayment', [EntrepreneurMiddleware::class]);
$router->get('/entrepreneur/view-application/{id}', 'App\Controllers\EntrepreneurController@viewApplication', [EntrepreneurMiddleware::class]);

// Investor routes
$router->get('/investor/dashboard', 'App\Controllers\InvestorController@dashboard', [InvestorMiddleware::class]);
$router->get('/investor/browse-startups', 'App\Controllers\InvestorController@browseStartups', [InvestorMiddleware::class]);
$router->get('/investor/view-startup/{id}', 'App\Controllers\InvestorController@viewStartup', [InvestorMiddleware::class]);
$router->post('/investor/invest', 'App\Controllers\InvestorController@invest', [InvestorMiddleware::class]);
$router->get('/investor/wallet', 'App\Controllers\InvestorController@wallet', [InvestorMiddleware::class]);
$router->post('/investor/deposit', 'App\Controllers\InvestorController@depositFunds', [InvestorMiddleware::class]);
$router->get('/investor/verify-deposit', 'App\Controllers\InvestorController@verifyDeposit', [InvestorMiddleware::class]);

// Admin routes
$router->get('/admin/dashboard', 'App\Controllers\AdminController@dashboard', [AdminMiddleware::class]);
$router->get('/admin/applications', 'App\Controllers\AdminController@applications', [AdminMiddleware::class]);
$router->get('/admin/view-application/{id}', 'App\Controllers\AdminController@viewApplication', [AdminMiddleware::class]);
$router->post('/admin/update-application-status', 'App\Controllers\AdminController@updateApplicationStatus', [AdminMiddleware::class]);
$router->get('/admin/form-builder', 'App\Controllers\AdminController@formBuilder', [AdminMiddleware::class]);
$router->post('/admin/add-form-field', 'App\Controllers\AdminController@addFormField', [AdminMiddleware::class]);
$router->post('/admin/update-form-field', 'App\Controllers\AdminController@updateFormField', [AdminMiddleware::class]);
$router->get('/admin/delete-form-field/{id}', 'App\Controllers\AdminController@deleteFormField', [AdminMiddleware::class]);
$router->get('/admin/users', 'App\Controllers\AdminController@users', [AdminMiddleware::class]);
$router->post('/admin/update-user-status', 'App\Controllers\AdminController@updateUserStatus', [AdminMiddleware::class]);
$router->get('/admin/transactions', 'App\Controllers\AdminController@transactions', [AdminMiddleware::class]);
$router->get('/admin/reports', 'App\Controllers\AdminController@reports', [AdminMiddleware::class]);

// Mentor routes
$router->get('/mentor/dashboard', 'App\Controllers\MentorController@dashboard', [MentorMiddleware::class]);
$router->get('/mentor/mentees', 'App\Controllers\MentorController@mentees', [MentorMiddleware::class]);
$router->get('/mentor/view-mentee/{id}', 'App\Controllers\MentorController@viewMentee', [MentorMiddleware::class]);
$router->post('/mentor/schedule-session', 'App\Controllers\MentorController@scheduleSession', [MentorMiddleware::class]);
$router->post('/mentor/complete-session', 'App\Controllers\MentorController@completeSession', [MentorMiddleware::class]);
$router->get('/mentor/resources', 'App\Controllers\MentorController@resources', [MentorMiddleware::class]);
$router->post('/mentor/upload-resource', 'App\Controllers\MentorController@uploadResource', [MentorMiddleware::class]);

return $router;
