<?php
// Stridevest Limited - Main Entry Point
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Define base path
define('BASE_PATH', dirname(__DIR__));

// Autoloader
spl_autoload_register(function ($class) {
    $prefix = 'App\\';
    $base_dir = BASE_PATH . '/app/';
    
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }
    
    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';
    
    if (file_exists($file)) {
        require $file;
    }
});

// Load helpers
require_once BASE_PATH . '/app/Helpers/helpers.php';

// Start session
use App\Core\Session;
Session::start();

// Load routes and dispatch
$router = require BASE_PATH . '/routes/web.php';
$router->dispatch();
