-- Stridevest Limited - Initial Seed Data

-- Insert default admin user (password: admin123)
INSERT INTO users (first_name, last_name, email, phone, password, role, email_verified, status)
VALUES ('Admin', 'User', 'admin@stridevestltd.com', '+2347034288000', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', TRUE, 'active');

-- Insert sample entrepreneur (password: password123)
INSERT INTO users (first_name, last_name, email, phone, password, role, email_verified, status)
VALUES ('John', 'Entrepreneur', 'entrepreneur@example.com', '+2348012345678', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'entrepreneur', TRUE, 'active');

-- Insert sample investor (password: password123)
INSERT INTO users (first_name, last_name, email, phone, password, role, email_verified, status)
VALUES ('Jane', 'Investor', 'investor@example.com', '+2348087654321', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'investor', TRUE, 'active');

-- Insert sample mentor (password: password123)
INSERT INTO users (first_name, last_name, email, phone, password, role, email_verified, status)
VALUES ('Michael', 'Mentor', 'mentor@example.com', '+2348098765432', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'mentor', TRUE, 'active');

-- Create wallets for all users
INSERT INTO wallets (user_id, balance) 
SELECT id, 0 FROM users;

-- Update investor wallet with sample balance
UPDATE wallets SET balance = 1000000 WHERE user_id = (SELECT id FROM users WHERE email = 'investor@example.com');

-- Insert default form fields
INSERT INTO form_fields (field_name, field_label, field_type, is_required, placeholder, help_text, field_order, is_active) VALUES
('business_description', 'Business Description', 'textarea', TRUE, 'Describe your business...', 'Provide a detailed description of your business', 1, TRUE),
('target_market', 'Target Market', 'textarea', TRUE, 'Who are your customers?', 'Describe your target market and customer base', 2, TRUE),
('revenue_model', 'Revenue Model', 'textarea', TRUE, 'How do you make money?', 'Explain your revenue generation strategy', 3, TRUE),
('team_size', 'Team Size', 'select', TRUE, '', 'Number of people in your team', 4, TRUE),
('years_in_operation', 'Years in Operation', 'number', TRUE, '0', 'How long has your business been operating?', 5, TRUE),
('monthly_revenue', 'Monthly Revenue (₦)', 'number', FALSE, '0', 'Average monthly revenue', 6, TRUE),
('funding_purpose', 'Purpose of Funding', 'textarea', TRUE, 'What will you use the funds for?', 'Explain how you plan to use the investment', 7, TRUE);

-- Update team_size field with options
UPDATE form_fields SET field_options = '["1-5", "6-10", "11-20", "21-50", "50+"]' WHERE field_name = 'team_size';

-- Insert system settings
INSERT INTO settings (setting_key, setting_value, setting_type, description) VALUES
('application_fee', '5000', 'number', 'Application submission fee in Naira'),
('min_investment', '100000', 'number', 'Minimum investment amount in Naira'),
('platform_commission', '20', 'number', 'Platform commission percentage'),
('investor_share', '40', 'number', 'Investor profit share percentage'),
('entrepreneur_share', '40', 'number', 'Entrepreneur profit share percentage'),
('maintenance_mode', 'false', 'boolean', 'Enable/disable maintenance mode'),
('site_name', 'Stridevest Limited', 'string', 'Website name'),
('site_email', 'info@stridevestltd.com', 'string', 'Contact email');

-- Insert sample badges
INSERT INTO badges (name, description, icon, badge_type, criteria) VALUES
('First Application', 'Submitted your first application', '🎯', 'entrepreneur', '{"applications": 1}'),
('Funded Startup', 'Successfully received funding', '💰', 'entrepreneur', '{"funded": true}'),
('First Investment', 'Made your first investment', '📈', 'investor', '{"investments": 1}'),
('Top Investor', 'Invested over ₦1,000,000', '👑', 'investor', '{"total_invested": 1000000}'),
('Mentor of the Year', 'Completed 50+ mentorship sessions', '🏆', 'mentor', '{"sessions": 50}'),
('Rising Star', 'Highly rated mentor', '⭐', 'mentor', '{"rating": 4.5}');

COMMIT;
