<?php require __DIR__ . '/../layouts/header.php'; ?>

<div class="dashboard-layout">
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2>Stridevest</h2>
        </div>
        <nav class="sidebar-nav">
            <a href="/mentor/dashboard" class="nav-item">
                <span>📊</span> Dashboard
            </a>
            <a href="/mentor/mentees" class="nav-item active">
                <span>👥</span> My Mentees
            </a>
            <a href="/mentor/resources" class="nav-item">
                <span>📚</span> Resources
            </a>
            <a href="/logout" class="nav-item">
                <span>🚪</span> Logout
            </a>
        </nav>
    </aside>
    
    <main class="dashboard-main">
        <div class="dashboard-header">
            <h1>My Mentees</h1>
            <p>Manage your mentorship relationships</p>
        </div>
        
        <div class="mentees-grid">
            <?php if (empty($mentees)): ?>
                <div class="empty-state" style="grid-column: 1 / -1;">
                    <p>You don't have any mentees yet.</p>
                </div>
            <?php else: ?>
                <?php foreach ($mentees as $mentee): ?>
                    <div class="mentee-card">
                        <div class="mentee-header">
                            <div class="mentee-avatar">
                                <?= strtoupper(substr($mentee['name'], 0, 1)) ?>
                            </div>
                            <div class="mentee-info">
                                <h3><?= htmlspecialchars($mentee['name']) ?></h3>
                                <p class="mentee-business"><?= htmlspecialchars($mentee['business_name']) ?></p>
                            </div>
                        </div>
                        
                        <div class="mentee-details">
                            <div class="detail">
                                <span class="label">Industry</span>
                                <span class="value"><?= ucfirst($mentee['industry']) ?></span>
                            </div>
                            <div class="detail">
                                <span class="label">Sessions</span>
                                <span class="value"><?= $mentee['sessions_completed'] ?></span>
                            </div>
                            <div class="detail">
                                <span class="label">Rating</span>
                                <span class="value">
                                    <?php for ($i = 0; $i < $mentee['rating']; $i++): ?>
                                        <span>⭐</span>
                                    <?php endfor; ?>
                                </span>
                            </div>
                        </div>
                        
                        <div class="mentee-actions">
                            <a href="/mentor/view-mentee/<?= $mentee['id'] ?>" class="btn btn-primary btn-sm">View Profile</a>
                            <button class="btn btn-outline btn-sm" onclick="scheduleSession(<?= $mentee['id'] ?>)">Schedule Session</button>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </main>
</div>

<style>
.mentees-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: var(--spacing-lg);
}

.mentee-card {
    background: white;
    border: 1px solid var(--color-border);
    border-radius: var(--radius-md);
    padding: var(--spacing-lg);
    transition: all 0.2s;
}

.mentee-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 24px rgba(0,0,0,0.08);
}

.mentee-header {
    display: flex;
    gap: var(--spacing-md);
    margin-bottom: var(--spacing-lg);
    padding-bottom: var(--spacing-lg);
    border-bottom: 1px solid var(--color-border);
}

.mentee-avatar {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: linear-gradient(135deg, var(--primary), var(--primary-dark));
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    font-weight: 700;
    flex-shrink: 0;
}

.mentee-info h3 {
    margin: 0 0 var(--spacing-xs) 0;
}

.mentee-business {
    margin: 0;
    font-size: 14px;
    color: var(--color-text-secondary);
}

.mentee-details {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: var(--spacing-md);
    margin-bottom: var(--spacing-lg);
}

.detail {
    display: flex;
    flex-direction: column;
    text-align: center;
}

.detail .label {
    font-size: 12px;
    color: var(--color-text-secondary);
    margin-bottom: var(--spacing-xs);
}

.detail .value {
    font-size: 16px;
    font-weight: 600;
}

.mentee-actions {
    display: flex;
    gap: var(--spacing-sm);
}

.btn-sm {
    padding: var(--spacing-sm) var(--spacing-md);
    font-size: 14px;
    flex: 1;
}

.empty-state {
    text-align: center;
    padding: var(--spacing-xl);
    background: var(--slate-1);
    border-radius: var(--radius-md);
}
</style>

<script>
function scheduleSession(menteeId) {
    alert('Schedule session with mentee ' + menteeId);
    // In production, this would open a scheduling modal
}
</script>

<?php require __DIR__ . '/../layouts/footer.php'; ?>
