<?php require __DIR__ . '/../layouts/header.php'; ?>

<div class="dashboard-layout">
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2>Stridevest</h2>
        </div>
        <nav class="sidebar-nav">
            <a href="/mentor/dashboard" class="nav-item active">
                <span>📊</span> Dashboard
            </a>
            <a href="/mentor/mentees" class="nav-item">
                <span>👥</span> My Mentees
            </a>
            <a href="/mentor/resources" class="nav-item">
                <span>📚</span> Resources
            </a>
            <a href="/logout" class="nav-item">
                <span>🚪</span> Logout
            </a>
        </nav>
    </aside>
    
    <main class="dashboard-main">
        <div class="dashboard-header">
            <h1>Mentor Dashboard</h1>
            <p>Manage your mentorship activities</p>
        </div>
        
        <div class="mentor-stats">
            <div class="stat-card">
                <h3><?= $stats['total_mentees'] ?? 0 ?></h3>
                <p>Active Mentees</p>
            </div>
            <div class="stat-card">
                <h3><?= $stats['total_sessions'] ?? 0 ?></h3>
                <p>Sessions Completed</p>
            </div>
            <div class="stat-card">
                <h3><?= number_format($stats['average_rating'] ?? 0, 1) ?>/5</h3>
                <p>Average Rating</p>
            </div>
            <div class="stat-card">
                <h3><?= $stats['resources_shared'] ?? 0 ?></h3>
                <p>Resources Shared</p>
            </div>
        </div>
        
        <div class="mentor-content">
            <div class="content-section">
                <h2>Upcoming Sessions</h2>
                <div class="sessions-list">
                    <?php if (empty($upcoming_sessions)): ?>
                        <p class="text-muted">No upcoming sessions scheduled.</p>
                    <?php else: ?>
                        <?php foreach ($upcoming_sessions as $session): ?>
                            <div class="session-item">
                                <div class="session-info">
                                    <h4><?= htmlspecialchars($session['mentee_name']) ?></h4>
                                    <p class="session-date">
                                        📅 <?= formatDate($session['scheduled_date']) ?> at <?= date('H:i', strtotime($session['scheduled_time'])) ?>
                                    </p>
                                    <p class="session-topic"><?= htmlspecialchars($session['topic']) ?></p>
                                </div>
                                <div class="session-actions">
                                    <button class="btn btn-sm btn-primary" onclick="startSession(<?= $session['id'] ?>)">Start</button>
                                    <button class="btn btn-sm btn-outline" onclick="rescheduleSession(<?= $session['id'] ?>)">Reschedule</button>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="content-section">
                <h2>Recent Mentee Feedback</h2>
                <div class="feedback-list">
                    <?php if (empty($recent_feedback)): ?>
                        <p class="text-muted">No feedback yet.</p>
                    <?php else: ?>
                        <?php foreach ($recent_feedback as $feedback): ?>
                            <div class="feedback-item">
                                <div class="feedback-header">
                                    <h4><?= htmlspecialchars($feedback['mentee_name']) ?></h4>
                                    <div class="rating">
                                        <?php for ($i = 0; $i < $feedback['rating']; $i++): ?>
                                            <span>⭐</span>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                                <p class="feedback-text"><?= htmlspecialchars($feedback['comment']) ?></p>
                                <small><?= formatDate($feedback['created_at']) ?></small>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </main>
</div>

<style>
.mentor-stats {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: var(--spacing-lg);
    margin-bottom: var(--spacing-xl);
}

.stat-card {
    background: white;
    border: 1px solid var(--color-border);
    border-radius: var(--radius-md);
    padding: var(--spacing-lg);
    text-align: center;
}

.stat-card h3 {
    margin: 0 0 var(--spacing-sm) 0;
    font-size: 32px;
}

.stat-card p {
    margin: 0;
    color: var(--color-text-secondary);
}

.mentor-content {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: var(--spacing-xl);
}

.content-section {
    background: white;
    border: 1px solid var(--color-border);
    border-radius: var(--radius-md);
    padding: var(--spacing-lg);
}

.content-section h2 {
    margin-top: 0;
    margin-bottom: var(--spacing-lg);
}

.sessions-list,
.feedback-list {
    display: flex;
    flex-direction: column;
    gap: var(--spacing-md);
}

.session-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: var(--spacing-md);
    background: var(--slate-1);
    border-radius: var(--radius-sm);
    border: 1px solid var(--color-border);
}

.session-info h4 {
    margin: 0 0 var(--spacing-xs) 0;
}

.session-date,
.session-topic {
    margin: 0 0 var(--spacing-xs) 0;
    font-size: 14px;
    color: var(--color-text-secondary);
}

.session-actions {
    display: flex;
    gap: var(--spacing-sm);
}

.feedback-item {
    padding: var(--spacing-md);
    background: var(--slate-1);
    border-radius: var(--radius-sm);
    border: 1px solid var(--color-border);
}

.feedback-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: var(--spacing-sm);
}

.feedback-header h4 {
    margin: 0;
}

.rating {
    display: flex;
    gap: var(--spacing-xs);
}

.feedback-text {
    margin: 0 0 var(--spacing-sm) 0;
    font-size: 14px;
    line-height: 1.5;
}

.feedback-item small {
    color: var(--color-text-secondary);
}

.btn-sm {
    padding: var(--spacing-xs) var(--spacing-sm);
    font-size: 12px;
}

.text-muted {
    color: var(--color-text-secondary);
    font-size: 14px;
}

@media (max-width: 1024px) {
    .mentor-content {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
function startSession(sessionId) {
    alert('Starting session ' + sessionId);
    // In production, this would open a video conferencing interface
}

function rescheduleSession(sessionId) {
    alert('Reschedule session ' + sessionId);
    // In production, this would open a date/time picker
}
</script>

<?php require __DIR__ . '/../layouts/footer.php'; ?>
