<?php require __DIR__ . '/../layouts/header.php'; ?>

<div class="dashboard-layout">
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2>Stridevest</h2>
        </div>
        <nav class="sidebar-nav">
            <a href="/investor/dashboard" class="nav-item">
                <span>📊</span> Dashboard
            </a>
            <a href="/investor/browse-startups" class="nav-item">
                <span>🔍</span> Browse Startups
            </a>
            <a href="/investor/wallet" class="nav-item active">
                <span>💰</span> Wallet
            </a>
            <a href="/investor/investments" class="nav-item">
                <span>📈</span> My Investments
            </a>
            <a href="/logout" class="nav-item">
                <span>🚪</span> Logout
            </a>
        </nav>
    </aside>
    
    <main class="dashboard-main">
        <div class="dashboard-header">
            <h1>Wallet Management</h1>
            <p>Manage your investment funds</p>
        </div>
        
        <div class="wallet-overview">
            <div class="wallet-card">
                <h3>Available Balance</h3>
                <p class="wallet-amount"><?= formatMoney($wallet['balance'] ?? 0) ?></p>
                <small>Ready to invest</small>
            </div>
            
            <div class="wallet-card">
                <h3>Invested Amount</h3>
                <p class="wallet-amount"><?= formatMoney($wallet['invested_amount'] ?? 0) ?></p>
                <small>Currently deployed</small>
            </div>
            
            <div class="wallet-card">
                <h3>Total Returns</h3>
                <p class="wallet-amount" style="color: var(--success);"><?= formatMoney($wallet['total_returns'] ?? 0) ?></p>
                <small>Profit earned</small>
            </div>
        </div>
        
        <div class="wallet-actions">
            <button class="btn btn-primary" onclick="openDepositModal()">+ Add Funds</button>
            <button class="btn btn-outline">Withdraw Funds</button>
        </div>
        
        <div class="transactions-section">
            <h2>Transaction History</h2>
            
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Description</th>
                            <th>Amount</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($transactions)): ?>
                            <tr>
                                <td colspan="5" class="text-center">No transactions yet</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($transactions as $transaction): ?>
                                <tr>
                                    <td><?= formatDate($transaction['created_at']) ?></td>
                                    <td>
                                        <span class="badge badge-<?= $transaction['type'] === 'deposit' ? 'success' : 'info' ?>">
                                            <?= ucfirst($transaction['type']) ?>
                                        </span>
                                    </td>
                                    <td><?= htmlspecialchars($transaction['description']) ?></td>
                                    <td><?= formatMoney($transaction['amount']) ?></td>
                                    <td>
                                        <span class="badge badge-<?= $transaction['status'] === 'completed' ? 'success' : 'warning' ?>">
                                            <?= ucfirst($transaction['status']) ?>
                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
</div>

<!-- Deposit Modal -->
<div id="depositModal" class="modal" style="display: none;">
    <div class="modal-content">
        <div class="modal-header">
            <h2>Add Funds to Wallet</h2>
            <button class="modal-close" onclick="closeDepositModal()">&times;</button>
        </div>
        
        <form method="POST" action="/investor/deposit" class="modal-body">
            <?= csrf_field() ?>
            
            <div class="form-group">
                <label>Amount (₦)</label>
                <input type="number" name="amount" min="1000" step="1000" placeholder="Enter amount" class="form-control" required>
                <small>Minimum: ₦1,000</small>
            </div>
            
            <div class="form-group">
                <label>Payment Method</label>
                <select name="payment_method" class="form-control" required>
                    <option value="">Select payment method</option>
                    <option value="paystack">Paystack</option>
                    <option value="bank_transfer">Bank Transfer</option>
                </select>
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-outline" onclick="closeDepositModal()">Cancel</button>
                <button type="submit" class="btn btn-primary">Proceed to Payment</button>
            </div>
        </form>
    </div>
</div>

<style>
.wallet-overview {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: var(--spacing-lg);
    margin-bottom: var(--spacing-xl);
}

.wallet-card {
    background: linear-gradient(135deg, var(--primary), var(--primary-dark));
    color: white;
    padding: var(--spacing-lg);
    border-radius: var(--radius-md);
    box-shadow: 0 4px 12px rgba(0, 102, 255, 0.2);
}

.wallet-card h3 {
    margin: 0 0 var(--spacing-md) 0;
    font-size: 14px;
    opacity: 0.9;
}

.wallet-amount {
    font-size: 32px;
    font-weight: 700;
    margin: 0 0 var(--spacing-sm) 0;
}

.wallet-card small {
    opacity: 0.8;
}

.wallet-actions {
    display: flex;
    gap: var(--spacing-md);
    margin-bottom: var(--spacing-xl);
}

.transactions-section {
    background: white;
    border: 1px solid var(--color-border);
    border-radius: var(--radius-md);
    padding: var(--spacing-lg);
}

.transactions-section h2 {
    margin-top: 0;
}

.table-responsive {
    overflow-x: auto;
}

.table {
    width: 100%;
    border-collapse: collapse;
}

.table th {
    background: var(--slate-2);
    padding: var(--spacing-md);
    text-align: left;
    font-weight: 600;
    border-bottom: 2px solid var(--color-border);
}

.table td {
    padding: var(--spacing-md);
    border-bottom: 1px solid var(--color-border);
}

.table tbody tr:hover {
    background: var(--slate-1);
}

.modal {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0,0,0,0.5);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1000;
}

.modal-content {
    background: white;
    border-radius: var(--radius-md);
    max-width: 500px;
    width: 90%;
    box-shadow: 0 20px 60px rgba(0,0,0,0.3);
}

.modal-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: var(--spacing-lg);
    border-bottom: 1px solid var(--color-border);
}

.modal-header h2 {
    margin: 0;
}

.modal-close {
    background: none;
    border: none;
    font-size: 24px;
    cursor: pointer;
    color: var(--color-text-secondary);
}

.modal-body {
    padding: var(--spacing-lg);
}

.modal-footer {
    display: flex;
    gap: var(--spacing-md);
    justify-content: flex-end;
    padding: var(--spacing-lg);
    border-top: 1px solid var(--color-border);
}

.text-center {
    text-align: center;
}
</style>

<script>
function openDepositModal() {
    document.getElementById('depositModal').style.display = 'flex';
}

function closeDepositModal() {
    document.getElementById('depositModal').style.display = 'none';
}

window.onclick = function(event) {
    const modal = document.getElementById('depositModal');
    if (event.target === modal) {
        modal.style.display = 'none';
    }
}
</script>

<?php require __DIR__ . '/../layouts/footer.php'; ?>
