<?php require __DIR__ . '/../layouts/header.php'; ?>

<div class="dashboard-layout">
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2>Stridevest</h2>
        </div>
        <nav class="sidebar-nav">
            <a href="/investor/dashboard" class="nav-item">
                <span>📊</span> Dashboard
            </a>
            <a href="/investor/browse-startups" class="nav-item">
                <span>🔍</span> Browse Startups
            </a>
            <a href="/investor/wallet" class="nav-item">
                <span>💰</span> Wallet
            </a>
            <a href="/investor/investments" class="nav-item active">
                <span>📈</span> My Investments
            </a>
            <a href="/logout" class="nav-item">
                <span>🚪</span> Logout
            </a>
        </nav>
    </aside>
    
    <main class="dashboard-main">
        <div class="dashboard-header">
            <h1>My Investments</h1>
            <p>Track your investment portfolio and returns</p>
        </div>
        
        <div class="portfolio-summary">
            <div class="summary-card">
                <h4>Total Invested</h4>
                <p class="summary-value"><?= formatMoney($portfolio['total_invested'] ?? 0) ?></p>
            </div>
            <div class="summary-card">
                <h4>Current Value</h4>
                <p class="summary-value"><?= formatMoney($portfolio['current_value'] ?? 0) ?></p>
            </div>
            <div class="summary-card">
                <h4>Total Returns</h4>
                <p class="summary-value" style="color: var(--success);">
                    <?= formatMoney($portfolio['total_returns'] ?? 0) ?>
                </p>
            </div>
            <div class="summary-card">
                <h4>ROI</h4>
                <p class="summary-value" style="color: var(--success);">
                    <?= number_format($portfolio['roi_percentage'] ?? 0, 2) ?>%
                </p>
            </div>
        </div>
        
        <div class="investments-section">
            <div class="section-header">
                <h2>Active Investments</h2>
                <div class="filter-tabs">
                    <button class="tab-btn active" onclick="filterInvestments('all')">All</button>
                    <button class="tab-btn" onclick="filterInvestments('active')">Active</button>
                    <button class="tab-btn" onclick="filterInvestments('completed')">Completed</button>
                </div>
            </div>
            
            <div class="investments-list">
                <?php if (empty($investments)): ?>
                    <div class="empty-state">
                        <p>No investments yet. Start by browsing available startups.</p>
                        <a href="/investor/browse-startups" class="btn btn-primary">Browse Startups</a>
                    </div>
                <?php else: ?>
                    <?php foreach ($investments as $investment): ?>
                        <div class="investment-item">
                            <div class="investment-header">
                                <div>
                                    <h3><?= htmlspecialchars($investment['business_name']) ?></h3>
                                    <p class="investment-date">
                                        Invested on <?= formatDate($investment['investment_date']) ?>
                                    </p>
                                </div>
                                <span class="badge badge-<?= $investment['status'] === 'active' ? 'success' : 'info' ?>">
                                    <?= ucfirst($investment['status']) ?>
                                </span>
                            </div>
                            
                            <div class="investment-details">
                                <div class="detail-item">
                                    <span class="label">Investment Amount</span>
                                    <span class="value"><?= formatMoney($investment['amount']) ?></span>
                                </div>
                                <div class="detail-item">
                                    <span class="label">Equity Share</span>
                                    <span class="value"><?= number_format($investment['equity_percentage'], 2) ?>%</span>
                                </div>
                                <div class="detail-item">
                                    <span class="label">Current Value</span>
                                    <span class="value"><?= formatMoney($investment['current_value']) ?></span>
                                </div>
                                <div class="detail-item">
                                    <span class="label">Returns</span>
                                    <span class="value" style="color: var(--success);">
                                        <?= formatMoney($investment['returns'] ?? 0) ?>
                                    </span>
                                </div>
                            </div>
                            
                            <div class="investment-progress">
                                <div class="progress-label">
                                    <span>Performance</span>
                                    <span><?= number_format($investment['roi_percentage'] ?? 0, 2) ?>%</span>
                                </div>
                                <div class="progress-bar">
                                    <div class="progress-fill" style="width: <?= min(100, max(0, $investment['roi_percentage'] ?? 0)) ?>%"></div>
                                </div>
                            </div>
                            
                            <a href="/investor/view-investment/<?= $investment['id'] ?>" class="btn btn-outline btn-sm">
                                View Details
                            </a>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </main>
</div>

<style>
.portfolio-summary {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: var(--spacing-lg);
    margin-bottom: var(--spacing-xl);
}

.summary-card {
    background: white;
    border: 1px solid var(--color-border);
    border-radius: var(--radius-md);
    padding: var(--spacing-lg);
    text-align: center;
}

.summary-card h4 {
    margin: 0 0 var(--spacing-md) 0;
    color: var(--color-text-secondary);
    font-size: 14px;
}

.summary-value {
    font-size: 28px;
    font-weight: 700;
    margin: 0;
}

.section-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: var(--spacing-lg);
}

.filter-tabs {
    display: flex;
    gap: var(--spacing-sm);
}

.tab-btn {
    background: white;
    border: 1px solid var(--color-border);
    padding: var(--spacing-sm) var(--spacing-md);
    border-radius: var(--radius-sm);
    cursor: pointer;
    font-size: 14px;
    transition: all 0.2s;
}

.tab-btn:hover {
    border-color: var(--primary);
    color: var(--primary);
}

.tab-btn.active {
    background: var(--primary);
    color: white;
    border-color: var(--primary);
}

.investments-list {
    display: flex;
    flex-direction: column;
    gap: var(--spacing-lg);
}

.investment-item {
    background: white;
    border: 1px solid var(--color-border);
    border-radius: var(--radius-md);
    padding: var(--spacing-lg);
    transition: all 0.2s;
}

.investment-item:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.08);
}

.investment-header {
    display: flex;
    justify-content: space-between;
    align-items: start;
    margin-bottom: var(--spacing-lg);
    padding-bottom: var(--spacing-lg);
    border-bottom: 1px solid var(--color-border);
}

.investment-header h3 {
    margin: 0 0 var(--spacing-xs) 0;
}

.investment-date {
    margin: 0;
    font-size: 14px;
    color: var(--color-text-secondary);
}

.investment-details {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: var(--spacing-lg);
    margin-bottom: var(--spacing-lg);
}

.detail-item {
    display: flex;
    flex-direction: column;
}

.detail-item .label {
    font-size: 12px;
    color: var(--color-text-secondary);
    margin-bottom: var(--spacing-xs);
}

.detail-item .value {
    font-size: 18px;
    font-weight: 600;
}

.investment-progress {
    margin-bottom: var(--spacing-lg);
}

.progress-label {
    display: flex;
    justify-content: space-between;
    margin-bottom: var(--spacing-sm);
    font-size: 14px;
}

.progress-bar {
    width: 100%;
    height: 8px;
    background: var(--slate-3);
    border-radius: 4px;
    overflow: hidden;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, var(--primary), var(--success));
    transition: width 0.3s;
}

.empty-state {
    text-align: center;
    padding: var(--spacing-xl);
    background: var(--slate-1);
    border-radius: var(--radius-md);
}

.empty-state p {
    margin-bottom: var(--spacing-lg);
}

.btn-sm {
    padding: var(--spacing-sm) var(--spacing-md);
    font-size: 14px;
}
</style>

<script>
function filterInvestments(status) {
    // Update active tab
    document.querySelectorAll('.tab-btn').forEach(btn => {
        btn.classList.remove('active');
    });
    event.target.classList.add('active');
    
    // Filter investments (in production, this would be a server-side filter)
    const items = document.querySelectorAll('.investment-item');
    items.forEach(item => {
        if (status === 'all') {
            item.style.display = 'block';
        } else {
            const badge = item.querySelector('.badge');
            if (badge && badge.textContent.toLowerCase().includes(status)) {
                item.style.display = 'block';
            } else {
                item.style.display = 'none';
            }
        }
    });
}
</script>

<?php require __DIR__ . '/../layouts/footer.php'; ?>
