<?php require __DIR__ . '/../layouts/header.php'; ?>

<div class="dashboard-layout">
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2>Stridevest</h2>
        </div>
        <nav class="sidebar-nav">
            <a href="/investor/dashboard" class="nav-item active">
                <span>📊</span> Dashboard
            </a>
            <a href="/investor/browse-startups" class="nav-item">
                <span>🔍</span> Browse Startups
            </a>
            <a href="/investor/wallet" class="nav-item">
                <span>💰</span> Wallet
            </a>
            <a href="/investor/investments" class="nav-item">
                <span>📈</span> My Investments
            </a>
            <a href="/investor/messages" class="nav-item">
                <span>💬</span> Messages
            </a>
            <a href="/investor/profile" class="nav-item">
                <span>👤</span> Profile
            </a>
            <a href="/logout" class="nav-item">
                <span>🚪</span> Logout
            </a>
        </nav>
    </aside>
    
    <main class="dashboard-main">
        <div class="dashboard-header">
            <h1>Welcome back, <?= auth()['first_name'] ?>!</h1>
            <p>Your investment portfolio overview</p>
        </div>
        
        <div class="stats-cards">
            <div class="stat-card">
                <div class="stat-icon">💰</div>
                <div class="stat-info">
                    <h3><?= formatMoney($wallet['balance']) ?></h3>
                    <p>Wallet Balance</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">📊</div>
                <div class="stat-info">
                    <h3><?= formatMoney($totalInvested) ?></h3>
                    <p>Total Invested</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">📈</div>
                <div class="stat-info">
                    <h3><?= formatMoney($totalReturns) ?></h3>
                    <p>Total Returns</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">🎯</div>
                <div class="stat-info">
                    <h3><?= count($investments) ?></h3>
                    <p>Active Investments</p>
                </div>
            </div>
        </div>
        
        <div class="dashboard-section" style="margin-bottom: var(--spacing-xl);">
            <div class="section-header">
                <h2>Quick Actions</h2>
            </div>
            <div class="quick-actions">
                <a href="/investor/browse-startups" class="action-card">
                    <div class="action-icon">🔍</div>
                    <h4>Browse Startups</h4>
                    <p>Discover new investment opportunities</p>
                </a>
                <a href="/investor/wallet" class="action-card">
                    <div class="action-icon">💳</div>
                    <h4>Fund Wallet</h4>
                    <p>Add money to your wallet</p>
                </a>
                <a href="/investor/reports" class="action-card">
                    <div class="action-icon">📊</div>
                    <h4>View Reports</h4>
                    <p>Check your investment performance</p>
                </a>
            </div>
        </div>
        
        <div class="dashboard-section">
            <div class="section-header">
                <h2>My Investments</h2>
                <a href="/investor/investments" class="btn btn-outline btn-sm">View All</a>
            </div>
            
            <div class="investments-list">
                <?php if (empty($investments)): ?>
                    <div class="empty-state">
                        <p>You haven't made any investments yet.</p>
                        <a href="/investor/browse-startups" class="btn btn-primary">Browse Startups</a>
                    </div>
                <?php else: ?>
                    <?php foreach (array_slice($investments, 0, 5) as $investment): ?>
                        <div class="investment-item">
                            <div class="investment-info">
                                <h4><?= htmlspecialchars($investment['business_name']) ?></h4>
                                <p><?= $investment['industry'] ?> • <?= formatDate($investment['investment_date']) ?></p>
                            </div>
                            <div class="investment-details">
                                <div class="investment-amount">
                                    <strong><?= formatMoney($investment['amount']) ?></strong>
                                    <small>Invested</small>
                                </div>
                                <div class="investment-roi">
                                    <strong><?= number_format($investment['expected_roi_percentage'], 1) ?>%</strong>
                                    <small>Expected ROI</small>
                                </div>
                                <span class="badge badge-<?= $investment['status'] ?>"><?= ucfirst($investment['status']) ?></span>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </main>
</div>

<style>
.quick-actions {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: var(--spacing-lg);
    margin-top: var(--spacing-lg);
}

.action-card {
    padding: var(--spacing-lg);
    background: white;
    border: 1px solid var(--color-border);
    border-radius: var(--radius-md);
    text-decoration: none;
    color: var(--color-text);
    transition: all 0.2s;
}

.action-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 24px rgba(0,0,0,0.08);
    border-color: var(--primary);
}

.action-icon {
    font-size: 32px;
    margin-bottom: var(--spacing-md);
}

.action-card h4 {
    font-size: 18px;
    margin-bottom: var(--spacing-sm);
}

.action-card p {
    color: var(--color-text-secondary);
    font-size: 14px;
    margin: 0;
}

.investments-list {
    display: flex;
    flex-direction: column;
    gap: var(--spacing-md);
}

.investment-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: var(--spacing-lg);
    background: var(--slate-1);
    border-radius: var(--radius-sm);
}

.investment-info h4 {
    font-size: 18px;
    margin-bottom: var(--spacing-xs);
}

.investment-info p {
    color: var(--color-text-muted);
    font-size: 14px;
    margin: 0;
}

.investment-details {
    display: flex;
    align-items: center;
    gap: var(--spacing-xl);
}

.investment-amount, .investment-roi {
    text-align: center;
}

.investment-amount strong, .investment-roi strong {
    display: block;
    font-size: 18px;
    margin-bottom: var(--spacing-xs);
}

.investment-amount small, .investment-roi small {
    font-size: 12px;
    color: var(--color-text-muted);
}
</style>

<?php require __DIR__ . '/../layouts/footer.php'; ?>
