<?php require __DIR__ . '/../layouts/header.php'; ?>

<div class="dashboard-layout">
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2>Stridevest</h2>
        </div>
        <nav class="sidebar-nav">
            <a href="/investor/dashboard" class="nav-item">
                <span>📊</span> Dashboard
            </a>
            <a href="/investor/browse-startups" class="nav-item active">
                <span>🔍</span> Browse Startups
            </a>
            <a href="/investor/wallet" class="nav-item">
                <span>💰</span> Wallet
            </a>
            <a href="/investor/investments" class="nav-item">
                <span>📈</span> My Investments
            </a>
            <a href="/logout" class="nav-item">
                <span>🚪</span> Logout
            </a>
        </nav>
    </aside>
    
    <main class="dashboard-main">
        <div class="dashboard-header">
            <h1>Browse Investment Opportunities</h1>
            <p>Discover verified startups seeking funding</p>
        </div>
        
        <div class="filter-section">
            <form method="GET" class="filter-form">
                <div class="form-group">
                    <input type="text" name="search" placeholder="Search by business name..." class="form-control" value="<?= $_GET['search'] ?? '' ?>">
                </div>
                
                <div class="form-group">
                    <select name="industry" class="form-control">
                        <option value="">All Industries</option>
                        <option value="technology" <?= ($_GET['industry'] ?? '') === 'technology' ? 'selected' : '' ?>>Technology</option>
                        <option value="agriculture" <?= ($_GET['industry'] ?? '') === 'agriculture' ? 'selected' : '' ?>>Agriculture</option>
                        <option value="healthcare" <?= ($_GET['industry'] ?? '') === 'healthcare' ? 'selected' : '' ?>>Healthcare</option>
                        <option value="education" <?= ($_GET['industry'] ?? '') === 'education' ? 'selected' : '' ?>>Education</option>
                        <option value="fintech" <?= ($_GET['industry'] ?? '') === 'fintech' ? 'selected' : '' ?>>Fintech</option>
                        <option value="retail" <?= ($_GET['industry'] ?? '') === 'retail' ? 'selected' : '' ?>>Retail</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <select name="sort" class="form-control">
                        <option value="newest" <?= ($_GET['sort'] ?? '') === 'newest' ? 'selected' : '' ?>>Newest First</option>
                        <option value="funding_high" <?= ($_GET['sort'] ?? '') === 'funding_high' ? 'selected' : '' ?>>Highest Funding</option>
                        <option value="funding_low" <?= ($_GET['sort'] ?? '') === 'funding_low' ? 'selected' : '' ?>>Lowest Funding</option>
                    </select>
                </div>
                
                <button type="submit" class="btn btn-primary">Filter</button>
            </form>
        </div>
        
        <div class="startups-grid">
            <?php if (empty($startups)): ?>
                <div class="empty-state" style="grid-column: 1 / -1;">
                    <p>No startups found matching your criteria.</p>
                </div>
            <?php else: ?>
                <?php foreach ($startups as $startup): ?>
                    <div class="startup-card">
                        <div class="startup-header">
                            <h3><?= htmlspecialchars($startup['business_name']) ?></h3>
                            <span class="badge badge-approved"><?= ucfirst($startup['industry']) ?></span>
                        </div>
                        
                        <p class="startup-description">
                            <?= htmlspecialchars(substr($startup['form_data']['business_description'] ?? '', 0, 150)) ?>...
                        </p>
                        
                        <div class="startup-stats">
                            <div class="stat">
                                <strong><?= formatMoney($startup['funding_amount']) ?></strong>
                                <small>Seeking</small>
                            </div>
                            <div class="stat">
                                <strong><?= formatMoney($startup['funded_amount'] ?? 0) ?></strong>
                                <small>Funded</small>
                            </div>
                            <div class="stat">
                                <strong><?= number_format((($startup['funded_amount'] ?? 0) / $startup['funding_amount']) * 100, 0) ?>%</strong>
                                <small>Progress</small>
                            </div>
                        </div>
                        
                        <div class="progress-bar">
                            <div class="progress-fill" style="width: <?= min(100, (($startup['funded_amount'] ?? 0) / $startup['funding_amount']) * 100) ?>%"></div>
                        </div>
                        
                        <a href="/investor/view-startup/<?= $startup['id'] ?>" class="btn btn-primary btn-block">View Details</a>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </main>
</div>

<style>
.filter-section {
    background: white;
    padding: var(--spacing-lg);
    border-radius: var(--radius-md);
    border: 1px solid var(--color-border);
    margin-bottom: var(--spacing-xl);
}

.filter-form {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: var(--spacing-md);
    align-items: flex-end;
}

.startups-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: var(--spacing-lg);
}

.startup-card {
    background: white;
    border: 1px solid var(--color-border);
    border-radius: var(--radius-md);
    padding: var(--spacing-lg);
    transition: all 0.2s;
}

.startup-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 24px rgba(0,0,0,0.08);
}

.startup-header {
    display: flex;
    justify-content: space-between;
    align-items: start;
    margin-bottom: var(--spacing-md);
}

.startup-header h3 {
    font-size: 20px;
    margin: 0;
}

.startup-description {
    color: var(--color-text-secondary);
    font-size: 14px;
    margin-bottom: var(--spacing-md);
}

.startup-stats {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: var(--spacing-md);
    margin-bottom: var(--spacing-md);
    text-align: center;
}

.startup-stats .stat strong {
    display: block;
    font-size: 16px;
    margin-bottom: var(--spacing-xs);
}

.startup-stats .stat small {
    font-size: 12px;
}

.progress-bar {
    width: 100%;
    height: 8px;
    background: var(--slate-3);
    border-radius: 4px;
    overflow: hidden;
    margin-bottom: var(--spacing-lg);
}

.progress-fill {
    height: 100%;
    background: var(--primary);
    transition: width 0.3s;
}
</style>

<?php require __DIR__ . '/../layouts/footer.php'; ?>
