<?php require __DIR__ . '/layouts/header.php'; ?>

<nav class="navbar">
    <div class="container">
        <div class="navbar-brand">
            <h2>Stridevest</h2>
        </div>
        <div class="navbar-menu">
            <a href="<?= url('/') ?>">Home</a>
            <a href="<?= url('/about') ?>">About</a>
            <a href="<?= url('/contact') ?>">Contact</a>
            <?php if (auth()): ?>
                <a href="<?= url('/logout') ?>" class="btn btn-outline">Logout</a>
            <?php else: ?>
                <a href="<?= url('/login') ?>" class="btn btn-outline">Login</a>
                <a href="<?= url('/register') ?>" class="btn btn-primary">Get Started</a>
            <?php endif; ?>
        </div>
    </div>
</nav>

<section class="hero">
    <div class="container">
        <div class="hero-content">
            <h1>Empowering Growth, Funding Dreams</h1>
            <p class="hero-subtitle">Connect Nigerian entrepreneurs with investors and mentors to build the next generation of successful businesses.</p>
            <div class="hero-cta">
                <a href="<?= url('/register') ?>" class="btn btn-primary btn-lg">Start Your Journey</a>
                <a href="<?= url('/about') ?>" class="btn btn-outline btn-lg">Learn More</a>
            </div>
        </div>
    </div>
</section>

<section class="features">
    <div class="container">
        <h2 class="section-title">How Stridevest Works</h2>
        
        <div class="features-grid">
            <div class="feature-card">
                <div class="feature-icon">🚀</div>
                <h3>For Entrepreneurs</h3>
                <p>Submit your business application for just ₦5,000 and get access to funding opportunities and expert mentorship.</p>
                <a href="<?= url('/register?role=entrepreneur') ?>" class="btn btn-text">Apply Now →</a>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">💰</div>
                <h3>For Investors</h3>
                <p>Discover verified startups, invest with confidence, and track your ROI with our transparent profit-sharing model.</p>
                <a href="<?= url('/register?role=investor') ?>" class="btn btn-text">Start Investing →</a>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">🎓</div>
                <h3>For Mentors</h3>
                <p>Share your expertise, guide emerging entrepreneurs, and make a lasting impact on Nigeria's business ecosystem.</p>
                <a href="<?= url('/register?role=mentor') ?>" class="btn btn-text">Become a Mentor →</a>
            </div>
        </div>
    </div>
</section>

<section class="stats">
    <div class="container">
        <div class="stats-grid">
            <div class="stat-item">
                <h3 class="stat-number">500+</h3>
                <p>Entrepreneurs Supported</p>
            </div>
            <div class="stat-item">
                <h3 class="stat-number">₦50M+</h3>
                <p>Total Investments</p>
            </div>
            <div class="stat-item">
                <h3 class="stat-number">100+</h3>
                <p>Expert Mentors</p>
            </div>
            <div class="stat-item">
                <h3 class="stat-number">85%</h3>
                <p>Success Rate</p>
            </div>
        </div>
    </div>
</section>

<section class="cta-section">
    <div class="container">
        <div class="cta-content">
            <h2>Ready to Transform Your Business?</h2>
            <p>Join thousands of entrepreneurs, investors, and mentors building the future of Nigerian business.</p>
            <a href="<?= url('/register') ?>" class="btn btn-primary btn-lg">Get Started Today</a>
        </div>
    </div>
</section>

<?php require __DIR__ . '/layouts/footer.php'; ?>
