<?php require __DIR__ . '/../layouts/header.php'; ?>

<div class="dashboard-layout">
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2>Stridevest</h2>
        </div>
        <nav class="sidebar-nav">
            <a href="/entrepreneur/dashboard" class="nav-item">
                <span>📊</span> Dashboard
            </a>
            <a href="/entrepreneur/apply" class="nav-item active">
                <span>📝</span> New Application
            </a>
        </nav>
    </aside>
    
    <main class="dashboard-main">
        <div class="dashboard-header">
            <h1>Complete Payment</h1>
            <p>Application Fee: <?= formatMoney($amount) ?></p>
        </div>
        
        <div class="payment-container">
            <div class="payment-card">
                <div class="payment-header">
                    <h3>Application Details</h3>
                </div>
                
                <div class="payment-details">
                    <div class="detail-row">
                        <span>Business Name:</span>
                        <strong><?= htmlspecialchars($application['business_name']) ?></strong>
                    </div>
                    <div class="detail-row">
                        <span>Application Number:</span>
                        <strong><?= $application['application_number'] ?></strong>
                    </div>
                    <div class="detail-row">
                        <span>Application Fee:</span>
                        <strong><?= formatMoney($amount) ?></strong>
                    </div>
                </div>
                
                <div class="payment-info">
                    <p>⚡ Secure payment powered by Paystack</p>
                    <p>💳 Pay with Card, Bank Transfer, or USSD</p>
                </div>
                
                <button onclick="payWithPaystack()" class="btn btn-primary btn-lg btn-block">
                    Pay <?= formatMoney($amount) ?> Now
                </button>
                
                <p class="text-center text-muted" style="margin-top: var(--spacing-md);">
                    Your application will be submitted for review after successful payment
                </p>
            </div>
        </div>
    </main>
</div>

<script src="https://js.paystack.co/v1/inline.js"></script>
<script>
const paystackPublicKey = '<?= $paystackPublicKey ?>';
const amount = <?= $amount * 100 ?>; // Convert to kobo
const email = '<?= auth()['email'] ?>';
const reference = 'APP-<?= $application['id'] ?>-' + Date.now();

function payWithPaystack() {
    const handler = PaystackPop.setup({
        key: paystackPublicKey,
        email: email,
        amount: amount,
        ref: reference,
        callback: function(response) {
            // Payment successful
            window.location.href = '/entrepreneur/verify-payment?reference=' + response.reference;
        },
        onClose: function() {
            alert('Payment window closed');
        }
    });
    handler.openIframe();
}
</script>

<style>
.payment-container {
    max-width: 600px;
    margin: 0 auto;
}

.payment-card {
    background: white;
    padding: var(--spacing-xl);
    border-radius: var(--radius-lg);
    border: 1px solid var(--color-border);
}

.payment-header {
    margin-bottom: var(--spacing-lg);
    padding-bottom: var(--spacing-lg);
    border-bottom: 1px solid var(--color-border);
}

.payment-header h3 {
    font-size: 24px;
    margin: 0;
}

.payment-details {
    margin-bottom: var(--spacing-xl);
}

.detail-row {
    display: flex;
    justify-content: space-between;
    padding: var(--spacing-md) 0;
    border-bottom: 1px solid var(--color-border);
}

.detail-row:last-child {
    border-bottom: none;
    font-size: 18px;
}

.payment-info {
    background: var(--slate-1);
    padding: var(--spacing-md);
    border-radius: var(--radius-sm);
    margin-bottom: var(--spacing-lg);
}

.payment-info p {
    margin-bottom: var(--spacing-sm);
    font-size: 14px;
}

.payment-info p:last-child {
    margin-bottom: 0;
}
</style>

<?php require __DIR__ . '/../layouts/footer.php'; ?>
