<?php require __DIR__ . '/../layouts/header.php'; ?>

<div class="dashboard-layout">
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2>Stridevest</h2>
        </div>
        <nav class="sidebar-nav">
            <a href="/entrepreneur/dashboard" class="nav-item active">
                <span>📊</span> Dashboard
            </a>
            <a href="/entrepreneur/apply" class="nav-item">
                <span>📝</span> New Application
            </a>
            <a href="/entrepreneur/applications" class="nav-item">
                <span>📋</span> My Applications
            </a>
            <a href="/entrepreneur/mentorship" class="nav-item">
                <span>🎓</span> Mentorship
            </a>
            <a href="/entrepreneur/messages" class="nav-item">
                <span>💬</span> Messages
            </a>
            <a href="/entrepreneur/profile" class="nav-item">
                <span>👤</span> Profile
            </a>
            <a href="/logout" class="nav-item">
                <span>🚪</span> Logout
            </a>
        </nav>
    </aside>
    
    <main class="dashboard-main">
        <div class="dashboard-header">
            <h1>Welcome back, <?= auth()['first_name'] ?>!</h1>
            <p>Here's what's happening with your applications</p>
        </div>
        
        <div class="stats-cards">
            <div class="stat-card">
                <div class="stat-icon">📝</div>
                <div class="stat-info">
                    <h3><?= count($applications) ?></h3>
                    <p>Total Applications</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">⏳</div>
                <div class="stat-info">
                    <h3><?= count(array_filter($applications, fn($a) => $a['status'] === 'pending')) ?></h3>
                    <p>Pending Review</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">✅</div>
                <div class="stat-info">
                    <h3><?= count(array_filter($applications, fn($a) => $a['status'] === 'approved')) ?></h3>
                    <p>Approved</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">🎓</div>
                <div class="stat-info">
                    <h3><?= count($mentorships) ?></h3>
                    <p>Active Mentorships</p>
                </div>
            </div>
        </div>
        
        <div class="dashboard-grid">
            <div class="dashboard-section">
                <div class="section-header">
                    <h2>Recent Applications</h2>
                    <a href="/entrepreneur/apply" class="btn btn-primary">New Application</a>
                </div>
                
                <div class="applications-list">
                    <?php if (empty($applications)): ?>
                        <div class="empty-state">
                            <p>You haven't submitted any applications yet.</p>
                            <a href="/entrepreneur/apply" class="btn btn-primary">Submit Your First Application</a>
                        </div>
                    <?php else: ?>
                        <?php foreach (array_slice($applications, 0, 5) as $app): ?>
                            <div class="application-item">
                                <div class="application-info">
                                    <h4><?= htmlspecialchars($app['business_name']) ?></h4>
                                    <p><?= $app['application_number'] ?> • <?= formatDate($app['created_at']) ?></p>
                                </div>
                                <div class="application-status">
                                    <span class="badge badge-<?= $app['status'] ?>"><?= ucfirst($app['status']) ?></span>
                                    <a href="/entrepreneur/view-application/<?= $app['id'] ?>" class="btn btn-sm">View</a>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="dashboard-section">
                <div class="section-header">
                    <h2>Notifications</h2>
                </div>
                
                <div class="notifications-list">
                    <?php if (empty($notifications)): ?>
                        <p class="text-muted">No new notifications</p>
                    <?php else: ?>
                        <?php foreach ($notifications as $notif): ?>
                            <div class="notification-item">
                                <div class="notification-icon"><?= $notif['type'] === 'success' ? '✅' : ($notif['type'] === 'error' ? '❌' : 'ℹ️') ?></div>
                                <div class="notification-content">
                                    <h4><?= htmlspecialchars($notif['title']) ?></h4>
                                    <p><?= htmlspecialchars($notif['message']) ?></p>
                                    <small><?= timeAgo($notif['created_at']) ?></small>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </main>
</div>

<?php require __DIR__ . '/../layouts/footer.php'; ?>
