<?php require __DIR__ . '/../layouts/header.php'; ?>

<div class="dashboard-layout">
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2>Stridevest</h2>
        </div>
        <nav class="sidebar-nav">
            <a href="/entrepreneur/dashboard" class="nav-item">
                <span>📊</span> Dashboard
            </a>
            <a href="/entrepreneur/apply" class="nav-item active">
                <span>📝</span> New Application
            </a>
            <a href="/entrepreneur/applications" class="nav-item">
                <span>📋</span> My Applications
            </a>
            <a href="/logout" class="nav-item">
                <span>🚪</span> Logout
            </a>
        </nav>
    </aside>
    
    <main class="dashboard-main">
        <div class="dashboard-header">
            <h1>Submit New Application</h1>
            <p>Application Fee: ₦5,000 (Payable after submission)</p>
        </div>
        
        <div class="form-container">
            <form method="POST" action="/entrepreneur/apply" enctype="multipart/form-data" class="application-form">
                <?= csrf_field() ?>
                
                <div class="form-section">
                    <h3>Basic Information</h3>
                    
                    <div class="form-group">
                        <label for="business_name">Business Name *</label>
                        <input type="text" id="business_name" name="business_name" required class="form-control">
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label for="business_type">Business Type *</label>
                            <select id="business_type" name="business_type" required class="form-control">
                                <option value="">Select type</option>
                                <option value="startup">Startup</option>
                                <option value="sme">SME</option>
                                <option value="enterprise">Enterprise</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="industry">Industry *</label>
                            <select id="industry" name="industry" required class="form-control">
                                <option value="">Select industry</option>
                                <option value="technology">Technology</option>
                                <option value="agriculture">Agriculture</option>
                                <option value="healthcare">Healthcare</option>
                                <option value="education">Education</option>
                                <option value="fintech">Fintech</option>
                                <option value="retail">Retail</option>
                                <option value="manufacturing">Manufacturing</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="funding_amount">Funding Amount Needed (₦) *</label>
                        <input type="number" id="funding_amount" name="funding_amount" required class="form-control" min="100000" step="1000">
                        <small>Minimum: ₦100,000</small>
                    </div>
                </div>
                
                <?php if (!empty($formFields)): ?>
                <div class="form-section">
                    <h3>Additional Information</h3>
                    
                    <?php foreach ($formFields as $field): ?>
                        <div class="form-group">
                            <label for="<?= $field['field_name'] ?>">
                                <?= htmlspecialchars($field['field_label']) ?>
                                <?= $field['is_required'] ? '*' : '' ?>
                            </label>
                            
                            <?php if ($field['field_type'] === 'textarea'): ?>
                                <textarea 
                                    id="<?= $field['field_name'] ?>" 
                                    name="<?= $field['field_name'] ?>" 
                                    <?= $field['is_required'] ? 'required' : '' ?>
                                    class="form-control"
                                    placeholder="<?= htmlspecialchars($field['placeholder']) ?>"
                                ></textarea>
                            <?php elseif ($field['field_type'] === 'select'): ?>
                                <select 
                                    id="<?= $field['field_name'] ?>" 
                                    name="<?= $field['field_name'] ?>" 
                                    <?= $field['is_required'] ? 'required' : '' ?>
                                    class="form-control"
                                >
                                    <option value="">Select option</option>
                                    <?php 
                                    $options = json_decode($field['field_options'], true) ?? [];
                                    foreach ($options as $option): 
                                    ?>
                                        <option value="<?= htmlspecialchars($option) ?>"><?= htmlspecialchars($option) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            <?php else: ?>
                                <input 
                                    type="<?= $field['field_type'] ?>" 
                                    id="<?= $field['field_name'] ?>" 
                                    name="<?= $field['field_name'] ?>" 
                                    <?= $field['is_required'] ? 'required' : '' ?>
                                    class="form-control"
                                    placeholder="<?= htmlspecialchars($field['placeholder']) ?>"
                                >
                            <?php endif; ?>
                            
                            <?php if ($field['help_text']): ?>
                                <small><?= htmlspecialchars($field['help_text']) ?></small>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
                
                <div class="form-section">
                    <h3>Documents</h3>
                    
                    <div class="form-group">
                        <label for="pitch_deck">Pitch Deck (PDF, PPT)</label>
                        <input type="file" id="pitch_deck" name="pitch_deck" class="form-control" accept=".pdf,.ppt,.pptx">
                        <small>Upload your business pitch deck</small>
                    </div>
                    
                    <div class="form-group">
                        <label for="business_plan">Business Plan (PDF)</label>
                        <input type="file" id="business_plan" name="business_plan" class="form-control" accept=".pdf">
                        <small>Upload your detailed business plan</small>
                    </div>
                    
                    <div class="form-group">
                        <label for="cac_document">CAC Registration Document</label>
                        <input type="file" id="cac_document" name="cac_document" class="form-control" accept=".pdf,.jpg,.jpeg,.png">
                        <small>Upload your CAC registration certificate</small>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary btn-lg">Submit Application</button>
                    <a href="/entrepreneur/dashboard" class="btn btn-outline">Cancel</a>
                </div>
            </form>
        </div>
    </main>
</div>

<?php require __DIR__ . '/../layouts/footer.php'; ?>
