<?php require __DIR__ . '/../layouts/header.php'; ?>

<div class="auth-container">
    <div class="auth-card">
        <div class="auth-header">
            <h1>Create Account</h1>
            <p>Join Stridevest and start your journey</p>
        </div>
        
        <form method="POST" action="/register" class="auth-form">
            <?= csrf_field() ?>
            
            <div class="form-row">
                <div class="form-group">
                    <label for="first_name">First Name</label>
                    <input type="text" id="first_name" name="first_name" required class="form-control">
                </div>
                
                <div class="form-group">
                    <label for="last_name">Last Name</label>
                    <input type="text" id="last_name" name="last_name" required class="form-control">
                </div>
            </div>
            
            <div class="form-group">
                <label for="email">Email Address</label>
                <input type="email" id="email" name="email" required class="form-control">
            </div>
            
            <div class="form-group">
                <label for="phone">Phone Number</label>
                <input type="tel" id="phone" name="phone" required class="form-control" placeholder="+234">
            </div>
            
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required class="form-control" minlength="8">
                <small>Minimum 8 characters</small>
            </div>
            
            <div class="form-group">
                <label for="role">I am a...</label>
                <select id="role" name="role" required class="form-control">
                    <option value="">Select your role</option>
                    <option value="entrepreneur">Entrepreneur (Seeking Funding)</option>
                    <option value="investor">Investor (Looking to Invest)</option>
                    <option value="mentor">Mentor (Offering Guidance)</option>
                </select>
            </div>
            
            <div class="form-group">
                <button type="submit" class="btn btn-primary btn-block">Create Account</button>
            </div>
            
            <div class="auth-footer">
                <p>Already have an account? <a href="/login">Login here</a></p>
            </div>
        </form>
    </div>
</div>

<?php require __DIR__ . '/../layouts/footer.php'; ?>
