<?php require __DIR__ . '/../layouts/header.php'; ?>

<div class="dashboard-layout">
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2>Stridevest Admin</h2>
        </div>
        <nav class="sidebar-nav">
            <a href="/admin/dashboard" class="nav-item">
                <span>📊</span> Dashboard
            </a>
            <a href="/admin/applications" class="nav-item active">
                <span>📋</span> Applications
            </a>
            <a href="/admin/form-builder" class="nav-item">
                <span>🔧</span> Form Builder
            </a>
            <a href="/admin/users" class="nav-item">
                <span>👥</span> Users
            </a>
            <a href="/admin/transactions" class="nav-item">
                <span>💳</span> Transactions
            </a>
            <a href="/admin/reports" class="nav-item">
                <span>📈</span> Reports
            </a>
            <a href="/logout" class="nav-item">
                <span>🚪</span> Logout
            </a>
        </nav>
    </aside>
    
    <main class="dashboard-main">
        <div class="dashboard-header">
            <h1>Review Application</h1>
            <a href="/admin/applications" class="btn btn-outline">← Back to Applications</a>
        </div>
        
        <div class="review-container">
            <div class="review-main">
                <!-- Application Overview -->
                <div class="review-card">
                    <h2>Application Overview</h2>
                    <div class="overview-grid">
                        <div class="overview-item">
                            <label>Business Name</label>
                            <p><?= htmlspecialchars($application['business_name']) ?></p>
                        </div>
                        <div class="overview-item">
                            <label>Entrepreneur</label>
                            <p><?= htmlspecialchars($application['entrepreneur_name']) ?></p>
                        </div>
                        <div class="overview-item">
                            <label>Email</label>
                            <p><?= htmlspecialchars($application['entrepreneur_email']) ?></p>
                        </div>
                        <div class="overview-item">
                            <label>Phone</label>
                            <p><?= htmlspecialchars($application['entrepreneur_phone']) ?></p>
                        </div>
                        <div class="overview-item">
                            <label>Industry</label>
                            <p><?= ucfirst($application['industry']) ?></p>
                        </div>
                        <div class="overview-item">
                            <label>Funding Amount</label>
                            <p><?= formatMoney($application['funding_amount']) ?></p>
                        </div>
                        <div class="overview-item">
                            <label>Status</label>
                            <p>
                                <span class="badge badge-<?= str_replace('_', '-', $application['status']) ?>">
                                    <?= ucfirst(str_replace('_', ' ', $application['status'])) ?>
                                </span>
                            </p>
                        </div>
                        <div class="overview-item">
                            <label>Submitted</label>
                            <p><?= formatDate($application['created_at']) ?></p>
                        </div>
                    </div>
                </div>
                
                <!-- Application Details -->
                <div class="review-card">
                    <h2>Business Details</h2>
                    <div class="details-content">
                        <?php if (!empty($application['form_data'])): ?>
                            <?php foreach ($application['form_data'] as $field => $value): ?>
                                <div class="detail-field">
                                    <label><?= ucfirst(str_replace('_', ' ', $field)) ?></label>
                                    <p><?= htmlspecialchars($value) ?></p>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Uploaded Documents -->
                <div class="review-card">
                    <h2>Uploaded Documents</h2>
                    <div class="documents-list">
                        <?php if (!empty($application['documents'])): ?>
                            <?php foreach ($application['documents'] as $doc): ?>
                                <div class="document-item">
                                    <span class="doc-icon">📄</span>
                                    <div class="doc-info">
                                        <p class="doc-name"><?= htmlspecialchars($doc['filename']) ?></p>
                                        <small><?= formatMoney($doc['file_size']) ?> • <?= formatDate($doc['uploaded_at']) ?></small>
                                    </div>
                                    <a href="<?= $doc['file_path'] ?>" class="btn btn-sm btn-outline" download>Download</a>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <p class="text-muted">No documents uploaded</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- Review Sidebar -->
            <aside class="review-sidebar">
                <div class="review-card">
                    <h3>Review Actions</h3>
                    
                    <?php if ($application['status'] === 'submitted' || $application['status'] === 'under_review'): ?>
                        <form method="POST" action="/admin/update-application-status" class="review-form">
                            <?= csrf_field() ?>
                            <input type="hidden" name="application_id" value="<?= $application['id'] ?>">
                            
                            <div class="form-group">
                                <label>Decision</label>
                                <select name="status" class="form-control" required>
                                    <option value="">Select decision</option>
                                    <option value="approved">Approve</option>
                                    <option value="rejected">Reject</option>
                                    <option value="under_review">Keep Under Review</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label>Comments</label>
                                <textarea name="comments" class="form-control" rows="4" placeholder="Add review comments..."></textarea>
                            </div>
                            
                            <button type="submit" class="btn btn-primary btn-block">Submit Review</button>
                        </form>
                    <?php else: ?>
                        <div class="status-info">
                            <p>This application has already been reviewed.</p>
                            <p class="status-badge">
                                <span class="badge badge-<?= str_replace('_', '-', $application['status']) ?>">
                                    <?= ucfirst(str_replace('_', ' ', $application['status'])) ?>
                                </span>
                            </p>
                        </div>
                    <?php endif; ?>
                </div>
                
                <!-- Review History -->
                <div class="review-card">
                    <h3>Review History</h3>
                    <div class="history-list">
                        <?php if (!empty($application['review_history'])): ?>
                            <?php foreach ($application['review_history'] as $review): ?>
                                <div class="history-item">
                                    <p class="history-date"><?= formatDate($review['reviewed_at']) ?></p>
                                    <p class="history-status">
                                        <span class="badge badge-<?= str_replace('_', '-', $review['status']) ?>">
                                            <?= ucfirst(str_replace('_', ' ', $review['status'])) ?>
                                        </span>
                                    </p>
                                    <p class="history-comment"><?= htmlspecialchars($review['comments']) ?></p>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <p class="text-muted">No review history</p>
                        <?php endif; ?>
                    </div>
                </div>
            </aside>
        </div>
    </main>
</div>

<style>
.review-container {
    display: grid;
    grid-template-columns: 1fr 350px;
    gap: var(--spacing-lg);
}

.review-main {
    display: flex;
    flex-direction: column;
    gap: var(--spacing-lg);
}

.review-card {
    background: white;
    border: 1px solid var(--color-border);
    border-radius: var(--radius-md);
    padding: var(--spacing-lg);
}

.review-card h2 {
    margin-top: 0;
    margin-bottom: var(--spacing-lg);
}

.review-card h3 {
    margin-top: 0;
    margin-bottom: var(--spacing-lg);
}

.overview-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: var(--spacing-lg);
}

.overview-item label {
    display: block;
    font-size: 12px;
    color: var(--color-text-secondary);
    margin-bottom: var(--spacing-xs);
    font-weight: 600;
}

.overview-item p {
    margin: 0;
    font-size: 16px;
}

.details-content {
    display: flex;
    flex-direction: column;
    gap: var(--spacing-lg);
}

.detail-field label {
    display: block;
    font-size: 12px;
    color: var(--color-text-secondary);
    margin-bottom: var(--spacing-xs);
    font-weight: 600;
}

.detail-field p {
    margin: 0;
    font-size: 14px;
    line-height: 1.6;
}

.documents-list {
    display: flex;
    flex-direction: column;
    gap: var(--spacing-md);
}

.document-item {
    display: flex;
    align-items: center;
    gap: var(--spacing-md);
    padding: var(--spacing-md);
    background: var(--slate-1);
    border-radius: var(--radius-sm);
}

.doc-icon {
    font-size: 24px;
}

.doc-info {
    flex: 1;
}

.doc-name {
    margin: 0 0 var(--spacing-xs) 0;
    font-weight: 600;
}

.doc-info small {
    color: var(--color-text-secondary);
}

.review-sidebar {
    display: flex;
    flex-direction: column;
    gap: var(--spacing-lg);
}

.review-form {
    display: flex;
    flex-direction: column;
    gap: var(--spacing-md);
}

.form-group {
    display: flex;
    flex-direction: column;
}

.form-group label {
    margin-bottom: var(--spacing-xs);
    font-weight: 600;
    font-size: 14px;
}

.form-control {
    padding: var(--spacing-sm);
    border: 1px solid var(--color-border);
    border-radius: var(--radius-sm);
    font-family: inherit;
    font-size: 14px;
}

.form-control:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(0, 102, 255, 0.1);
}

.btn-block {
    width: 100%;
}

.status-info {
    text-align: center;
    padding: var(--spacing-lg) 0;
}

.status-badge {
    display: block;
    margin-top: var(--spacing-md);
}

.history-list {
    display: flex;
    flex-direction: column;
    gap: var(--spacing-md);
}

.history-item {
    padding: var(--spacing-md);
    background: var(--slate-1);
    border-radius: var(--radius-sm);
}

.history-date {
    margin: 0 0 var(--spacing-xs) 0;
    font-size: 12px;
    color: var(--color-text-secondary);
}

.history-status {
    margin: 0 0 var(--spacing-xs) 0;
}

.history-comment {
    margin: 0;
    font-size: 14px;
    line-height: 1.4;
}

.text-muted {
    color: var(--color-text-secondary);
    font-size: 14px;
}

@media (max-width: 1024px) {
    .review-container {
        grid-template-columns: 1fr;
    }
}
</style>

<?php require __DIR__ . '/../layouts/footer.php'; ?>
