<?php require __DIR__ . '/../layouts/header.php'; ?>

<div class="dashboard-layout">
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2>Stridevest Admin</h2>
        </div>
        <nav class="sidebar-nav">
            <a href="/admin/dashboard" class="nav-item">
                <span>📊</span> Dashboard
            </a>
            <a href="/admin/applications" class="nav-item">
                <span>📋</span> Applications
            </a>
            <a href="/admin/form-builder" class="nav-item active">
                <span>🔧</span> Form Builder
            </a>
            <a href="/admin/users" class="nav-item">
                <span>👥</span> Users
            </a>
            <a href="/admin/transactions" class="nav-item">
                <span>💳</span> Transactions
            </a>
            <a href="/admin/reports" class="nav-item">
                <span>📈</span> Reports
            </a>
            <a href="/logout" class="nav-item">
                <span>🚪</span> Logout
            </a>
        </nav>
    </aside>
    
    <main class="dashboard-main">
        <div class="dashboard-header">
            <h1>Application Form Builder</h1>
            <p>Customize the application form fields</p>
        </div>
        
        <div class="builder-container">
            <!-- Form Preview -->
            <div class="form-preview">
                <h2>Form Preview</h2>
                <div class="preview-form">
                    <?php if (empty($form_fields)): ?>
                        <p class="text-muted">No form fields yet. Add fields to get started.</p>
                    <?php else: ?>
                        <?php foreach ($form_fields as $field): ?>
                            <div class="preview-field">
                                <label><?= htmlspecialchars($field['label']) ?></label>
                                <?php if ($field['type'] === 'text'): ?>
                                    <input type="text" placeholder="<?= htmlspecialchars($field['placeholder'] ?? '') ?>" disabled>
                                <?php elseif ($field['type'] === 'textarea'): ?>
                                    <textarea placeholder="<?= htmlspecialchars($field['placeholder'] ?? '') ?>" disabled></textarea>
                                <?php elseif ($field['type'] === 'select'): ?>
                                    <select disabled>
                                        <option>Select an option</option>
                                    </select>
                                <?php elseif ($field['type'] === 'file'): ?>
                                    <input type="file" disabled>
                                <?php elseif ($field['type'] === 'email'): ?>
                                    <input type="email" placeholder="<?= htmlspecialchars($field['placeholder'] ?? '') ?>" disabled>
                                <?php elseif ($field['type'] === 'number'): ?>
                                    <input type="number" placeholder="<?= htmlspecialchars($field['placeholder'] ?? '') ?>" disabled>
                                <?php endif; ?>
                                <?php if ($field['required']): ?>
                                    <small class="required-indicator">* Required</small>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Field Management -->
            <div class="field-management">
                <h2>Manage Fields</h2>
                
                <!-- Add New Field -->
                <div class="add-field-section">
                    <h3>Add New Field</h3>
                    <form method="POST" action="/admin/add-form-field" class="add-field-form">
                        <?= csrf_field() ?>
                        
                        <div class="form-group">
                            <label>Field Label</label>
                            <input type="text" name="label" class="form-control" placeholder="e.g., Business Description" required>
                        </div>
                        
                        <div class="form-group">
                            <label>Field Type</label>
                            <select name="type" class="form-control" required>
                                <option value="">Select type</option>
                                <option value="text">Text Input</option>
                                <option value="email">Email Input</option>
                                <option value="number">Number Input</option>
                                <option value="textarea">Text Area</option>
                                <option value="select">Dropdown</option>
                                <option value="file">File Upload</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label>Placeholder</label>
                            <input type="text" name="placeholder" class="form-control" placeholder="Optional placeholder text">
                        </div>
                        
                        <div class="form-group">
                            <label>
                                <input type="checkbox" name="required" value="1">
                                Make this field required
                            </label>
                        </div>
                        
                        <button type="submit" class="btn btn-primary btn-block">Add Field</button>
                    </form>
                </div>
                
                <!-- Existing Fields -->
                <div class="existing-fields">
                    <h3>Current Fields</h3>
                    
                    <?php if (empty($form_fields)): ?>
                        <p class="text-muted">No fields added yet.</p>
                    <?php else: ?>
                        <div class="fields-list">
                            <?php foreach ($form_fields as $field): ?>
                                <div class="field-item">
                                    <div class="field-info">
                                        <p class="field-label"><?= htmlspecialchars($field['label']) ?></p>
                                        <p class="field-type">
                                            <span class="badge badge-info"><?= ucfirst($field['type']) ?></span>
                                            <?php if ($field['required']): ?>
                                                <span class="badge badge-warning">Required</span>
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                    <div class="field-actions">
                                        <button class="btn btn-sm btn-outline" onclick="editField(<?= $field['id'] ?>)">Edit</button>
                                        <form method="POST" action="/admin/delete-form-field/<?= $field['id'] ?>" style="display: inline;">
                                            <?= csrf_field() ?>
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Delete this field?')">Delete</button>
                                        </form>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </main>
</div>

<style>
.builder-container {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: var(--spacing-xl);
}

.form-preview,
.field-management {
    background: white;
    border: 1px solid var(--color-border);
    border-radius: var(--radius-md);
    padding: var(--spacing-lg);
}

.form-preview h2,
.field-management h2 {
    margin-top: 0;
    margin-bottom: var(--spacing-lg);
}

.preview-form {
    display: flex;
    flex-direction: column;
    gap: var(--spacing-lg);
}

.preview-field {
    display: flex;
    flex-direction: column;
    gap: var(--spacing-sm);
}

.preview-field label {
    font-weight: 600;
    font-size: 14px;
}

.preview-field input,
.preview-field textarea,
.preview-field select {
    padding: var(--spacing-sm);
    border: 1px solid var(--color-border);
    border-radius: var(--radius-sm);
    font-family: inherit;
    font-size: 14px;
    background: var(--slate-1);
    cursor: not-allowed;
}

.required-indicator {
    color: var(--error);
    font-size: 12px;
}

.add-field-section {
    background: var(--slate-1);
    padding: var(--spacing-lg);
    border-radius: var(--radius-md);
    margin-bottom: var(--spacing-lg);
}

.add-field-section h3 {
    margin-top: 0;
    margin-bottom: var(--spacing-lg);
}

.add-field-form {
    display: flex;
    flex-direction: column;
    gap: var(--spacing-md);
}

.form-group {
    display: flex;
    flex-direction: column;
    gap: var(--spacing-xs);
}

.form-group label {
    font-weight: 600;
    font-size: 14px;
}

.form-control {
    padding: var(--spacing-sm);
    border: 1px solid var(--color-border);
    border-radius: var(--radius-sm);
    font-family: inherit;
    font-size: 14px;
}

.form-control:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(0, 102, 255, 0.1);
}

.form-group input[type="checkbox"] {
    width: auto;
    margin-right: var(--spacing-sm);
}

.btn-block {
    width: 100%;
}

.existing-fields {
    margin-top: var(--spacing-lg);
}

.existing-fields h3 {
    margin-top: 0;
    margin-bottom: var(--spacing-lg);
}

.fields-list {
    display: flex;
    flex-direction: column;
    gap: var(--spacing-md);
}

.field-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: var(--spacing-md);
    background: var(--slate-1);
    border-radius: var(--radius-sm);
    border: 1px solid var(--color-border);
}

.field-info {
    flex: 1;
}

.field-label {
    margin: 0 0 var(--spacing-xs) 0;
    font-weight: 600;
}

.field-type {
    margin: 0;
    display: flex;
    gap: var(--spacing-sm);
}

.badge {
    display: inline-block;
    padding: var(--spacing-xs) var(--spacing-sm);
    border-radius: var(--radius-sm);
    font-size: 12px;
    font-weight: 600;
}

.badge-info {
    background: #E3F2FD;
    color: #1976D2;
}

.badge-warning {
    background: #FFF3E0;
    color: #F57C00;
}

.field-actions {
    display: flex;
    gap: var(--spacing-sm);
}

.btn-sm {
    padding: var(--spacing-xs) var(--spacing-sm);
    font-size: 12px;
}

.btn-danger {
    background: var(--error);
    color: white;
    border: none;
}

.btn-danger:hover {
    background: #D32F2F;
}

.text-muted {
    color: var(--color-text-secondary);
    font-size: 14px;
}

@media (max-width: 1024px) {
    .builder-container {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
function editField(fieldId) {
    // In production, this would open an edit modal or navigate to edit page
    alert('Edit functionality coming soon for field ' + fieldId);
}
</script>

<?php require __DIR__ . '/../layouts/footer.php'; ?>
