<?php require __DIR__ . '/../layouts/header.php'; ?>

<div class="dashboard-layout">
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2>Stridevest Admin</h2>
        </div>
        <nav class="sidebar-nav">
            <a href="/admin/dashboard" class="nav-item active">
                <span>📊</span> Dashboard
            </a>
            <a href="/admin/applications" class="nav-item">
                <span>📋</span> Applications
            </a>
            <a href="/admin/form-builder" class="nav-item">
                <span>🔧</span> Form Builder
            </a>
            <a href="/admin/users" class="nav-item">
                <span>👥</span> Users
            </a>
            <a href="/admin/transactions" class="nav-item">
                <span>💳</span> Transactions
            </a>
            <a href="/admin/reports" class="nav-item">
                <span>📈</span> Reports
            </a>
            <a href="/logout" class="nav-item">
                <span>🚪</span> Logout
            </a>
        </nav>
    </aside>
    
    <main class="dashboard-main">
        <div class="dashboard-header">
            <h1>Admin Dashboard</h1>
            <p>Platform overview and key metrics</p>
        </div>
        
        <div class="metrics-grid">
            <div class="metric-card">
                <div class="metric-icon" style="background: #E3F2FD;">📊</div>
                <div class="metric-content">
                    <h3><?= $stats['total_applications'] ?? 0 ?></h3>
                    <p>Total Applications</p>
                </div>
            </div>
            
            <div class="metric-card">
                <div class="metric-icon" style="background: #F3E5F5;">✅</div>
                <div class="metric-content">
                    <h3><?= $stats['approved_applications'] ?? 0 ?></h3>
                    <p>Approved</p>
                </div>
            </div>
            
            <div class="metric-card">
                <div class="metric-icon" style="background: #FFF3E0;">⏳</div>
                <div class="metric-content">
                    <h3><?= $stats['pending_applications'] ?? 0 ?></h3>
                    <p>Pending Review</p>
                </div>
            </div>
            
            <div class="metric-card">
                <div class="metric-icon" style="background: #E8F5E9;">💰</div>
                <div class="metric-content">
                    <h3><?= formatMoney($stats['total_invested'] ?? 0) ?></h3>
                    <p>Total Invested</p>
                </div>
            </div>
            
            <div class="metric-card">
                <div class="metric-icon" style="background: #FCE4EC;">👥</div>
                <div class="metric-content">
                    <h3><?= $stats['total_users'] ?? 0 ?></h3>
                    <p>Total Users</p>
                </div>
            </div>
            
            <div class="metric-card">
                <div class="metric-icon" style="background: #E0F2F1;">💵</div>
                <div class="metric-content">
                    <h3><?= formatMoney($stats['platform_revenue'] ?? 0) ?></h3>
                    <p>Platform Revenue</p>
                </div>
            </div>
        </div>
        
        <div class="dashboard-content">
            <div class="content-section">
                <h2>Recent Applications</h2>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Business Name</th>
                                <th>Entrepreneur</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Submitted</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($recent_applications)): ?>
                                <tr>
                                    <td colspan="6" class="text-center">No applications yet</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($recent_applications as $app): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($app['business_name']) ?></td>
                                        <td><?= htmlspecialchars($app['entrepreneur_name']) ?></td>
                                        <td><?= formatMoney($app['funding_amount']) ?></td>
                                        <td>
                                            <span class="badge badge-<?= $app['status'] ?>">
                                                <?= ucfirst($app['status']) ?>
                                            </span>
                                        </td>
                                        <td><?= formatDate($app['created_at']) ?></td>
                                        <td>
                                            <a href="/admin/view-application/<?= $app['id'] ?>" class="btn btn-sm btn-outline">
                                                Review
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <a href="/admin/applications" class="btn btn-outline">View All Applications</a>
            </div>
            
            <div class="content-section">
                <h2>Recent Transactions</h2>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Reference</th>
                                <th>User</th>
                                <th>Type</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($recent_transactions)): ?>
                                <tr>
                                    <td colspan="6" class="text-center">No transactions yet</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($recent_transactions as $txn): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($txn['reference']) ?></td>
                                        <td><?= htmlspecialchars($txn['user_name']) ?></td>
                                        <td>
                                            <span class="badge badge-<?= $txn['type'] ?>">
                                                <?= ucfirst($txn['type']) ?>
                                            </span>
                                        </td>
                                        <td><?= formatMoney($txn['amount']) ?></td>
                                        <td>
                                            <span class="badge badge-<?= $txn['status'] ?>">
                                                <?= ucfirst($txn['status']) ?>
                                            </span>
                                        </td>
                                        <td><?= formatDate($txn['created_at']) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <a href="/admin/transactions" class="btn btn-outline">View All Transactions</a>
            </div>
        </div>
    </main>
</div>

<style>
.metrics-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: var(--spacing-lg);
    margin-bottom: var(--spacing-xl);
}

.metric-card {
    background: white;
    border: 1px solid var(--color-border);
    border-radius: var(--radius-md);
    padding: var(--spacing-lg);
    display: flex;
    gap: var(--spacing-lg);
    align-items: center;
    transition: all 0.2s;
}

.metric-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.08);
}

.metric-icon {
    width: 60px;
    height: 60px;
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 28px;
}

.metric-content h3 {
    margin: 0 0 var(--spacing-xs) 0;
    font-size: 24px;
}

.metric-content p {
    margin: 0;
    font-size: 14px;
    color: var(--color-text-secondary);
}

.dashboard-content {
    display: grid;
    grid-template-columns: 1fr;
    gap: var(--spacing-xl);
}

.content-section {
    background: white;
    border: 1px solid var(--color-border);
    border-radius: var(--radius-md);
    padding: var(--spacing-lg);
}

.content-section h2 {
    margin-top: 0;
    margin-bottom: var(--spacing-lg);
}

.table-responsive {
    overflow-x: auto;
    margin-bottom: var(--spacing-lg);
}

.table {
    width: 100%;
    border-collapse: collapse;
}

.table th {
    background: var(--slate-2);
    padding: var(--spacing-md);
    text-align: left;
    font-weight: 600;
    border-bottom: 2px solid var(--color-border);
}

.table td {
    padding: var(--spacing-md);
    border-bottom: 1px solid var(--color-border);
}

.table tbody tr:hover {
    background: var(--slate-1);
}

.btn-sm {
    padding: var(--spacing-sm) var(--spacing-md);
    font-size: 14px;
}

.text-center {
    text-align: center;
}

@media (max-width: 768px) {
    .metrics-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .table {
        font-size: 14px;
    }
    
    .table th, .table td {
        padding: var(--spacing-sm);
    }
}
</style>

<?php require __DIR__ . '/../layouts/footer.php'; ?>
