<?php require __DIR__ . '/../layouts/header.php'; ?>

<div class="dashboard-layout">
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2>Stridevest Admin</h2>
        </div>
        <nav class="sidebar-nav">
            <a href="/admin/dashboard" class="nav-item">
                <span>📊</span> Dashboard
            </a>
            <a href="/admin/applications" class="nav-item active">
                <span>📋</span> Applications
            </a>
            <a href="/admin/form-builder" class="nav-item">
                <span>🔧</span> Form Builder
            </a>
            <a href="/admin/users" class="nav-item">
                <span>👥</span> Users
            </a>
            <a href="/admin/transactions" class="nav-item">
                <span>💳</span> Transactions
            </a>
            <a href="/admin/reports" class="nav-item">
                <span>📈</span> Reports
            </a>
            <a href="/logout" class="nav-item">
                <span>🚪</span> Logout
            </a>
        </nav>
    </aside>
    
    <main class="dashboard-main">
        <div class="dashboard-header">
            <h1>Application Management</h1>
            <p>Review and manage startup applications</p>
        </div>
        
        <div class="filter-section">
            <form method="GET" class="filter-form">
                <div class="form-group">
                    <input type="text" name="search" placeholder="Search by business name..." class="form-control" value="<?= $_GET['search'] ?? '' ?>">
                </div>
                
                <div class="form-group">
                    <select name="status" class="form-control">
                        <option value="">All Status</option>
                        <option value="draft" <?= ($_GET['status'] ?? '') === 'draft' ? 'selected' : '' ?>>Draft</option>
                        <option value="submitted" <?= ($_GET['status'] ?? '') === 'submitted' ? 'selected' : '' ?>>Submitted</option>
                        <option value="under_review" <?= ($_GET['status'] ?? '') === 'under_review' ? 'selected' : '' ?>>Under Review</option>
                        <option value="approved" <?= ($_GET['status'] ?? '') === 'approved' ? 'selected' : '' ?>>Approved</option>
                        <option value="rejected" <?= ($_GET['status'] ?? '') === 'rejected' ? 'selected' : '' ?>>Rejected</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <select name="sort" class="form-control">
                        <option value="newest" <?= ($_GET['sort'] ?? '') === 'newest' ? 'selected' : '' ?>>Newest First</option>
                        <option value="oldest" <?= ($_GET['sort'] ?? '') === 'oldest' ? 'selected' : '' ?>>Oldest First</option>
                        <option value="amount_high" <?= ($_GET['sort'] ?? '') === 'amount_high' ? 'selected' : '' ?>>Highest Amount</option>
                    </select>
                </div>
                
                <button type="submit" class="btn btn-primary">Filter</button>
            </form>
        </div>
        
        <div class="applications-section">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Business Name</th>
                            <th>Entrepreneur</th>
                            <th>Industry</th>
                            <th>Funding Amount</th>
                            <th>Status</th>
                            <th>Submitted</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($applications)): ?>
                            <tr>
                                <td colspan="7" class="text-center">No applications found</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($applications as $app): ?>
                                <tr>
                                    <td>
                                        <strong><?= htmlspecialchars($app['business_name']) ?></strong>
                                    </td>
                                    <td><?= htmlspecialchars($app['entrepreneur_name']) ?></td>
                                    <td><?= ucfirst($app['industry']) ?></td>
                                    <td><?= formatMoney($app['funding_amount']) ?></td>
                                    <td>
                                        <span class="badge badge-<?= str_replace('_', '-', $app['status']) ?>">
                                            <?= ucfirst(str_replace('_', ' ', $app['status'])) ?>
                                        </span>
                                    </td>
                                    <td><?= formatDate($app['created_at']) ?></td>
                                    <td>
                                        <a href="/admin/view-application/<?= $app['id'] ?>" class="btn btn-sm btn-primary">
                                            Review
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        
        <div class="pagination">
            <?php if ($current_page > 1): ?>
                <a href="?page=<?= $current_page - 1 ?>" class="btn btn-outline">← Previous</a>
            <?php endif; ?>
            
            <span class="page-info">Page <?= $current_page ?> of <?= $total_pages ?></span>
            
            <?php if ($current_page < $total_pages): ?>
                <a href="?page=<?= $current_page + 1 ?>" class="btn btn-outline">Next →</a>
            <?php endif; ?>
        </div>
    </main>
</div>

<style>
.filter-section {
    background: white;
    padding: var(--spacing-lg);
    border-radius: var(--radius-md);
    border: 1px solid var(--color-border);
    margin-bottom: var(--spacing-xl);
}

.filter-form {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: var(--spacing-md);
    align-items: flex-end;
}

.applications-section {
    background: white;
    border: 1px solid var(--color-border);
    border-radius: var(--radius-md);
    padding: var(--spacing-lg);
    margin-bottom: var(--spacing-lg);
}

.table-responsive {
    overflow-x: auto;
}

.table {
    width: 100%;
    border-collapse: collapse;
}

.table th {
    background: var(--slate-2);
    padding: var(--spacing-md);
    text-align: left;
    font-weight: 600;
    border-bottom: 2px solid var(--color-border);
}

.table td {
    padding: var(--spacing-md);
    border-bottom: 1px solid var(--color-border);
}

.table tbody tr:hover {
    background: var(--slate-1);
}

.badge {
    display: inline-block;
    padding: var(--spacing-xs) var(--spacing-sm);
    border-radius: var(--radius-sm);
    font-size: 12px;
    font-weight: 600;
}

.badge-draft {
    background: var(--slate-3);
    color: var(--slate-11);
}

.badge-submitted {
    background: #E3F2FD;
    color: #1976D2;
}

.badge-under-review {
    background: #FFF3E0;
    color: #F57C00;
}

.badge-approved {
    background: #E8F5E9;
    color: #388E3C;
}

.badge-rejected {
    background: #FFEBEE;
    color: #D32F2F;
}

.pagination {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: var(--spacing-md);
}

.page-info {
    font-size: 14px;
    color: var(--color-text-secondary);
}

.btn-sm {
    padding: var(--spacing-sm) var(--spacing-md);
    font-size: 14px;
}

.text-center {
    text-align: center;
}

@media (max-width: 768px) {
    .filter-form {
        grid-template-columns: 1fr;
    }
    
    .table {
        font-size: 14px;
    }
    
    .table th, .table td {
        padding: var(--spacing-sm);
    }
}
</style>

<?php require __DIR__ . '/../layouts/footer.php'; ?>
