<?php
namespace App\Middleware;

use App\Core\Auth;
use App\Core\Session;

class RoleMiddleware {
    private $allowedRoles;
    
    public function __construct($roles = []) {
        $this->allowedRoles = is_array($roles) ? $roles : [$roles];
    }
    
    public function handle() {
        if (!Auth::check()) {
            Session::flash('error', 'Please login to continue');
            redirect('/login');
            return false;
        }
        
        if (!in_array(Auth::role(), $this->allowedRoles)) {
            Session::flash('error', 'You do not have permission to access this page');
            redirect('/');
            return false;
        }
        
        return true;
    }
}

class AdminMiddleware extends RoleMiddleware {
    public function __construct() {
        parent::__construct(['admin']);
    }
}

class EntrepreneurMiddleware extends RoleMiddleware {
    public function __construct() {
        parent::__construct(['entrepreneur']);
    }
}

class InvestorMiddleware extends RoleMiddleware {
    public function __construct() {
        parent::__construct(['investor']);
    }
}

class MentorMiddleware extends RoleMiddleware {
    public function __construct() {
        parent::__construct(['mentor']);
    }
}
