<?php
namespace App\Core;

class Router {
    private $routes = [];
    private $middlewares = [];
    
    public function get($path, $callback, $middlewares = []) {
        $this->addRoute('GET', $path, $callback, $middlewares);
    }
    
    public function post($path, $callback, $middlewares = []) {
        $this->addRoute('POST', $path, $callback, $middlewares);
    }
    
    private function addRoute($method, $path, $callback, $middlewares) {
        $this->routes[] = [
            'method' => $method,
            'path' => $path,
            'callback' => $callback,
            'middlewares' => $middlewares
        ];
    }
    
    public function dispatch() {
        $requestMethod = $_SERVER['REQUEST_METHOD'];
        $requestUri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        
        foreach ($this->routes as $route) {
            if ($route['method'] === $requestMethod && $this->matchPath($route['path'], $requestUri, $params)) {
                // Run middlewares
                foreach ($route['middlewares'] as $middleware) {
                    $middlewareInstance = new $middleware();
                    if (!$middlewareInstance->handle()) {
                        return;
                    }
                }
                
                // Execute callback
                if (is_callable($route['callback'])) {
                    call_user_func_array($route['callback'], $params);
                } else {
                    list($controller, $method) = explode('@', $route['callback']);
                    $controllerInstance = new $controller();
                    call_user_func_array([$controllerInstance, $method], $params);
                }
                return;
            }
        }
        
        // 404 Not Found
        http_response_code(404);
        echo "404 - Page Not Found";
    }
    
    private function matchPath($routePath, $requestUri, &$params) {
        $params = [];
        $routePath = preg_replace('/\{([a-zA-Z0-9_]+)\}/', '([^/]+)', $routePath);
        $routePath = '#^' . $routePath . '$#';
        
        if (preg_match($routePath, $requestUri, $matches)) {
            array_shift($matches);
            $params = $matches;
            return true;
        }
        
        return false;
    }
}
