<?php
namespace App\Core;

class Auth {
    private static $user = null;
    
    public static function login($user) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_role'] = $user['role'];
        $_SESSION['user_email'] = $user['email'];
        self::$user = $user;
        
        // Update last login
        $db = Database::getInstance();
        $db->execute(
            "UPDATE users SET last_login = CURRENT_TIMESTAMP, login_attempts = 0 WHERE id = ?",
            [$user['id']]
        );
    }
    
    public static function logout() {
        self::$user = null;
        session_destroy();
    }
    
    public static function check() {
        return isset($_SESSION['user_id']);
    }
    
    public static function user() {
        if (self::$user === null && isset($_SESSION['user_id'])) {
            $db = Database::getInstance();
            self::$user = $db->fetchOne(
                "SELECT * FROM users WHERE id = ?",
                [$_SESSION['user_id']]
            );
        }
        return self::$user;
    }
    
    public static function id() {
        return $_SESSION['user_id'] ?? null;
    }
    
    public static function role() {
        return $_SESSION['user_role'] ?? null;
    }
    
    public static function isAdmin() {
        return self::role() === 'admin';
    }
    
    public static function isEntrepreneur() {
        return self::role() === 'entrepreneur';
    }
    
    public static function isInvestor() {
        return self::role() === 'investor';
    }
    
    public static function isMentor() {
        return self::role() === 'mentor';
    }
    
    public static function hasRole($role) {
        return self::role() === $role;
    }
    
    public static function attempt($email, $password) {
        $db = Database::getInstance();
        $user = $db->fetchOne(
            "SELECT * FROM users WHERE email = ? AND status = 'active'",
            [$email]
        );
        
        if (!$user) {
            return false;
        }
        
        // Check if account is locked
        if ($user['locked_until'] && strtotime($user['locked_until']) > time()) {
            return ['error' => 'Account is temporarily locked. Please try again later.'];
        }
        
        if (password_verify($password, $user['password'])) {
            self::login($user);
            return true;
        } else {
            // Increment login attempts
            $attempts = $user['login_attempts'] + 1;
            $lockedUntil = null;
            
            if ($attempts >= 5) {
                $lockedUntil = date('Y-m-d H:i:s', strtotime('+30 minutes'));
            }
            
            $db->execute(
                "UPDATE users SET login_attempts = ?, locked_until = ? WHERE id = ?",
                [$attempts, $lockedUntil, $user['id']]
            );
            
            return false;
        }
    }
    
    public static function generateToken($length = 32) {
        return bin2hex(random_bytes($length));
    }
    
    public static function hashPassword($password) {
        return password_hash($password, PASSWORD_BCRYPT);
    }
}
